/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWFilterConditionsPanel;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWIndexTableModel
extends AbstractTableModel {
    public static final int MIN_ROW = 0;
    public static final int MAX_ROW = 1;
    public static final int ROW_LABEL_COL = 0;
    public static final int INCLUSIVE_COL = 1;
    private final int ROW_COUNT = 2;
    private final int MINIMUM_COLUMNS = 2;
    private int[] m_nColumnTypes = null;
    private String[] m_columnNames = null;
    private Object[] m_rowData = null;
    private boolean m_bErrValidating = false;

    public int getQueryFlags() {
        Boolean bValue = null;
        int nFlags = 0;
        bValue = (Boolean)this.getValueAt(0, 1);
        if (bValue != null && bValue.booleanValue()) {
            nFlags = 32;
        }
        if ((bValue = (Boolean)this.getValueAt(1, 1)) != null && bValue.booleanValue()) {
            nFlags |= 0x40;
        }
        return nFlags;
    }

    public void setQueryFlags(int nFlags) {
        Boolean bValue = null;
        bValue = (nFlags & 0x20) != 0 ? new Boolean(true) : new Boolean(false);
        this.setValueAt(bValue, 0, 1);
        this.fireTableCellUpdated(0, 1);
        bValue = (nFlags & 0x40) != 0 ? new Boolean(true) : new Boolean(false);
        this.setValueAt(bValue, 1, 1);
        this.fireTableCellUpdated(1, 1);
    }

    public Object[] getRowValues(int nRowIndex) {
        Object[] items = null;
        try {
            if (this.getColumnCount() > 2) {
                items = new Object[this.getColumnCount() - 2];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = this.getValueAt(nRowIndex, i + 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    public void setRowValues(Object[] items, int nRowIndex) {
        try {
            for (int nColIndex = 0; nColIndex < items.length; ++nColIndex) {
                this.setValueAt(items[nColIndex], nRowIndex, nColIndex + 2);
                this.fireTableCellUpdated(nRowIndex, nColIndex + 2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void initialize(VWIndexDefinition indexDef, VWExposedFieldDefinition[] exposedFields) {
        String[] fieldNames = null;
        Object[] record = null;
        try {
            if (indexDef != null) {
                fieldNames = indexDef.getFieldNames();
                if (fieldNames == null) {
                    return;
                }
                this.m_columnNames = new String[fieldNames.length + 2];
                this.m_nColumnTypes = new int[fieldNames.length + 2];
                this.m_columnNames[0] = " ";
                this.m_nColumnTypes[0] = 2;
                this.m_columnNames[1] = VWResource.s_inclusive;
                this.m_nColumnTypes[1] = 4;
                for (int nIndex = 2; nIndex < this.m_columnNames.length; ++nIndex) {
                    this.m_columnNames[nIndex] = fieldNames[nIndex - 2];
                    this.m_nColumnTypes[nIndex] = this.getFieldType(this.m_columnNames[nIndex], exposedFields);
                }
                this.m_rowData = new Object[2];
                record = new Object[this.m_columnNames.length];
                record[0] = VWResource.s_min;
                record[1] = new Boolean(true);
                this.m_rowData[0] = record;
                record = new Object[this.m_columnNames.length];
                record[0] = VWResource.s_max;
                record[1] = new Boolean(true);
                this.m_rowData[1] = record;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        if (this.m_nColumnTypes == null || nColumnIndex < 0 || nColumnIndex >= this.m_nColumnTypes.length) {
            return null;
        }
        switch (this.m_nColumnTypes[nColumnIndex]) {
            case 4: {
                return Boolean.class;
            }
            case 8: {
                return Double.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 16: {
                return Date.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        if (this.m_columnNames == null) {
            return 0;
        }
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumnIndex) {
        if (this.m_columnNames == null || nColumnIndex < 0 || nColumnIndex >= this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumnIndex];
    }

    public int getRowCount() {
        if (this.m_rowData == null) {
            return 0;
        }
        return this.m_rowData.length;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        Object[] record = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex >= this.m_rowData.length) {
            return null;
        }
        if (this.m_nColumnTypes == null || nColumnIndex < 0 || nColumnIndex >= this.m_nColumnTypes.length) {
            return null;
        }
        record = (Object[])this.m_rowData[nRowIndex];
        if (record == null) {
            return null;
        }
        return record[nColumnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        Object[] record = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex >= this.m_rowData.length) {
            return;
        }
        if (this.m_nColumnTypes == null || nColumnIndex < 0 || nColumnIndex >= this.m_nColumnTypes.length) {
            return;
        }
        record = (Object[])this.m_rowData[nRowIndex];
        if (record == null) {
            return;
        }
        if (aValue == null) {
            record[nColumnIndex] = null;
            return;
        }
        switch (this.m_nColumnTypes[nColumnIndex]) {
            case 4: {
                try {
                    Boolean newBooleanValue = null;
                    if (aValue instanceof Boolean) {
                        newBooleanValue = (Boolean)aValue;
                    } else if (VWStringUtils.compareIgnoreCase((String)aValue, VWResource.s_true) == 0 || VWStringUtils.compareIgnoreCase((String)aValue, "1") == 0) {
                        newBooleanValue = new Boolean(true);
                    } else if (VWStringUtils.compareIgnoreCase((String)aValue, VWResource.s_false) == 0 || VWStringUtils.compareIgnoreCase((String)aValue, "0") == 0) {
                        newBooleanValue = new Boolean(false);
                    } else {
                        this.setErrorValidatingFlag(true);
                        JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                        break;
                    }
                    record[nColumnIndex] = newBooleanValue;
                }
                catch (NumberFormatException ex) {
                    this.setErrorValidatingFlag(true);
                    JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                }
                break;
            }
            case 8: {
                try {
                    Double newFloatValue = null;
                    if (aValue instanceof Double) {
                        newFloatValue = (Double)aValue;
                    } else {
                        double aDouble = VWFieldsCellRenderer.parse((String)aValue).doubleValue();
                        newFloatValue = new Double(aDouble);
                    }
                    record[nColumnIndex] = newFloatValue;
                }
                catch (NumberFormatException ex) {
                    this.setErrorValidatingFlag(true);
                    JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                }
                catch (ParseException ex) {
                    this.setErrorValidatingFlag(true);
                    JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                }
                break;
            }
            case 1: {
                try {
                    Integer newIntValue = null;
                    newIntValue = aValue instanceof Integer ? (Integer)aValue : new Integer((String)aValue);
                    record[nColumnIndex] = newIntValue;
                }
                catch (NumberFormatException ex) {
                    this.setErrorValidatingFlag(true);
                    JOptionPane.showMessageDialog(null, VWResource.s_invalidIntegerFormat, VWResource.s_error, 1, null);
                }
                break;
            }
            case 2: {
                if (VWStringUtils.compare((String)aValue, "") == 0) {
                    record[nColumnIndex] = null;
                    break;
                }
                record[nColumnIndex] = (String)aValue;
                break;
            }
            case 16: {
                Date aDate = null;
                if (aValue != null && (aDate = aValue instanceof Date ? (Date)aValue : VWFilterConditionsPanel.convertToDate((String)aValue)) == null) {
                    this.setErrorValidatingFlag(true);
                }
                record[nColumnIndex] = aDate;
            }
        }
    }

    protected boolean getErrorValidatingFlag() {
        return this.m_bErrValidating;
    }

    protected void setErrorValidatingFlag(boolean flag) {
        this.m_bErrValidating = flag;
    }

    private int getFieldType(String fieldName, VWExposedFieldDefinition[] exposedFields) {
        for (int nIndex = 0; nIndex < exposedFields.length; ++nIndex) {
            if (VWStringUtils.compare(fieldName, exposedFields[nIndex].getName()) != 0) continue;
            return exposedFields[nIndex].getFieldType();
        }
        return -1;
    }
}

